unit Utils;

//################################################
interface uses Kernel;
//################################################

procedure TimeToStr(pTime:PFILETIME; pBuff:PCHAR);
procedure StampToTime(Stamp:NAT32; pBuff:PFILETIME);
function DecToInt(pDecStr:PCHAR) : INT32;

procedure MemSet4x(pDest:POINTER; Value,Count:NAT32);
function CopyText(pDst,pSrc:PCHAR; Max:NAT32; Term:CHAR) : NAT32;

function GetCmdArgsW(pArgPtrs:PVOID; BufSize:NAT32; pCmdStr:PWCHAR) : NAT32;

//################################################
implementation
//################################################

{$LINK 'Utils.obj'}

var

	sz_DateFmt : array [0..11] of CHAR = 'dd/MM/yyyy ';
	sz_TimeFmt : array [0..8] of CHAR  = 'HH:mm:ss';

procedure TimeToStr;
var
	t_sys : SYSTEMTIME;
	t_loc : FILETIME;
begin
	FileTimeToLocalFileTime(pTime, @t_loc);
	FileTimeToSystemTime(@t_loc, @t_sys);
	GetDateFormatA($00, $00, @t_sys, @sz_DateFmt, pBuff, 256);
	GetTimeFormatA($00, $00, @t_sys, @sz_TimeFmt, pBuff + sizeof(sz_DateFmt) - 1, 256);
end;

procedure StampToTime; external;
function DecToInt; external;

procedure MemSet4x; external;
function CopyText; external;

function GetCmdArgsW; external;

end.
